/**
* \file: FSAuthenticator.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2015 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#include <adit_logging.h>
#include <fstream>
#include "FSAuthenticator.h"

using namespace std;

LOG_IMPORT_CONTEXT(aauto_authentication)

namespace adit { namespace aauto {

FSAuthenticator::FSAuthenticator() {}

FSAuthenticator::~FSAuthenticator() {}

bool FSAuthenticator::setCertificates(shared_ptr<GalReceiver> inReceiver)
{
    bool result = false;

    if (inReceiver == nullptr)
        return result;

    string rootCert = getRootCert();
    string clientCert = getClientCert();
    string privateKey = getPrivateKey();

    result = inReceiver->setClientCreds(rootCert, clientCert, privateKey);

    /* overwrite the stack/heap */
    memset((void*)rootCert.data(), 0, rootCert.length());
    memset((void*)clientCert.data(), 0, clientCert.length());
    memset((void*)privateKey.data(), 0, privateKey.length());

    /* necessary to avoid that the compiler removes the memset operation above */
    asm volatile("" ::: "memory");

    return result;
}

void FSAuthenticator::setConfigItem(std::string inKey, std::string inValue)
{
    config.insert(pair<string, string>(inKey, inValue));
}

bool FSAuthenticator::getConfigItem(const string& inKey, string& outResult)
{
    outResult = "";

    auto found = config.find(inKey);
    if (found != config.end())
    {
        outResult = found->second;
        return true;
    }

    return false;
}

string FSAuthenticator::pullFromFileSystem(const string& inFileName)
{
    string mStr = "";

    // create input file stream for wrapped certificate
    ifstream mFile(inFileName, ios::in | ios::ate);
    if(!mFile.is_open())
    {
        LOG_ERROR((aauto_authentication, "Could not open the certificate"));
        return "";
    }

    // get size of wrapped certificate and allocate a buffer for that size
    // safeguard is assumed to be 1MB
    streampos mSize = mFile.tellg();
    if(mSize == -1 || mSize > 1024*1024)
    {
        LOG_ERROR((aauto_authentication, "Could not read the certificate "
                "or the file is larger than expected"));
        return "";
    }
    char mBuffer[(int)mSize];

    // read file to the buffer and close file
    mFile.seekg(0, ios::beg);
    mFile.read(mBuffer, mSize);
    mFile.close();

    mStr.assign(mBuffer, mSize);

    // return unwrapped certificate
    return mStr;
}

string FSAuthenticator::getRootCert()
{
    string path = "";
    if(!getConfigItem("rootCertificate", path))
    {
        LOG_ERROR((aauto_authentication, "Path to root certificate was not set properly"));
        return "";
    }

    return pullFromFileSystem(path);
}

string FSAuthenticator::getClientCert()
{
    string path = "";
    if(!getConfigItem("clientCertificate", path))
    {
        LOG_ERROR((aauto_authentication, "Path to client certificate was not set properly"));
        return "";
    }

    return pullFromFileSystem(path);
}

string FSAuthenticator::getPrivateKey()
{
    string path = "";
    if(!getConfigItem("privateKey", path))
    {
        LOG_ERROR((aauto_authentication, "Path to private key was not set properly"));
        return "";
    }

    return pullFromFileSystem(path);
}

} } /* namespace adit { namespace aauto { */
